//
// ========================================================================
// Copyright (c) 1995 Mort Bay Consulting Pty Ltd and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// https://www.eclipse.org/legal/epl-2.0, or the Apache License, Version 2.0
// which is available at https://www.apache.org/licenses/LICENSE-2.0.
//
// SPDX-License-Identifier: EPL-2.0 OR Apache-2.0
// ========================================================================
//

package org.eclipse.jetty.ee9.servlets;

import org.eclipse.jetty.toolchain.test.jupiter.WorkDir;
import org.eclipse.jetty.toolchain.test.jupiter.WorkDirExtension;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(WorkDirExtension.class)
public class CloseableDoSFilterTest extends AbstractDoSFilterTest
{
    @BeforeEach
    public void setUp(WorkDir workDir) throws Exception
    {
        startServer(workDir.getEmptyPathDir(), CloseableDoSFilter.class);
    }

    @Override
    @Test
    @Tag("flaky")
    public void testUnavailableIP() throws Exception
    {
        super.testUnavailableIP();
    }

    @Override
    @Test
    @Tag("flaky")
    public void testEvenLowRateIP() throws Exception
    {
        super.testEvenLowRateIP();
    }

}
