/*
 * This file was generated by mib2c and is intended for use as
 * a mib module for the ucd-snmp snmpd agent. 
 */


/*
 * This should always be included first before anything else 
 */
#include <net-snmp/net-snmp-config.h>
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif


/*
 * minimal include directives 
 */
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>

#include "header_complex.h"
#include "mteTriggerThresholdTable.h"
#include "mteTriggerTable.h"


/*
 * mteTriggerThresholdTable_variables_oid:
 *   this is the top level oid that we want to register under.  This
 *   is essentially a prefix, with the suffix appearing in the
 *   variable below.
 */


oid             mteTriggerThresholdTable_variables_oid[] =
    { 1, 3, 6, 1, 2, 1, 88, 1, 2, 6 };


/*
 * variable2 mteTriggerThresholdTable_variables:
 *   this variable defines function callbacks and type return information 
 *   for the mteTriggerThresholdTable mib section 
 */


#ifndef NETSNMP_NO_WRITE_SUPPORT
struct variable2 mteTriggerThresholdTable_variables[] = {
    /*
     * magic number        , variable type , ro/rw , callback fn  , L, oidsuffix 
     */
#define   MTETRIGGERTHRESHOLDSTARTUP  3
    {MTETRIGGERTHRESHOLDSTARTUP, ASN_INTEGER, NETSNMP_OLDAPI_RWRITE,
     var_mteTriggerThresholdTable, 2, {1, 1}},
#define   MTETRIGGERTHRESHOLDRISING  4
    {MTETRIGGERTHRESHOLDRISING, ASN_INTEGER, NETSNMP_OLDAPI_RWRITE,
     var_mteTriggerThresholdTable, 2, {1, 2}},
#define   MTETRIGGERTHRESHOLDFALLING  5
    {MTETRIGGERTHRESHOLDFALLING, ASN_INTEGER, NETSNMP_OLDAPI_RWRITE,
     var_mteTriggerThresholdTable, 2, {1, 3}},
#define   MTETRIGGERTHRESHOLDDELTARISING  6
    {MTETRIGGERTHRESHOLDDELTARISING, ASN_INTEGER, NETSNMP_OLDAPI_RWRITE,
     var_mteTriggerThresholdTable, 2, {1, 4}},
#define   MTETRIGGERTHRESHOLDDELTAFALLING  7
    {MTETRIGGERTHRESHOLDDELTAFALLING, ASN_INTEGER, NETSNMP_OLDAPI_RWRITE,
     var_mteTriggerThresholdTable, 2, {1, 5}},
#define   MTETRIGGERTHRESHOLDOBJECTSOWNER  8
    {MTETRIGGERTHRESHOLDOBJECTSOWNER, ASN_OCTET_STR, NETSNMP_OLDAPI_RWRITE,
     var_mteTriggerThresholdTable, 2, {1, 6}},
#define   MTETRIGGERTHRESHOLDOBJECTS  9
    {MTETRIGGERTHRESHOLDOBJECTS, ASN_OCTET_STR, NETSNMP_OLDAPI_RWRITE,
     var_mteTriggerThresholdTable, 2, {1, 7}},
#define   MTETRIGGERTHRESHOLDRISINGEVENTOWNER  10
    {MTETRIGGERTHRESHOLDRISINGEVENTOWNER, ASN_OCTET_STR, NETSNMP_OLDAPI_RWRITE,
     var_mteTriggerThresholdTable, 2, {1, 8}},
#define   MTETRIGGERTHRESHOLDRISINGEVENT  11
    {MTETRIGGERTHRESHOLDRISINGEVENT, ASN_OCTET_STR, NETSNMP_OLDAPI_RWRITE,
     var_mteTriggerThresholdTable, 2, {1, 9}},
#define   MTETRIGGERTHRESHOLDFALLINGEVENTOWNER  12
    {MTETRIGGERTHRESHOLDFALLINGEVENTOWNER, ASN_OCTET_STR, NETSNMP_OLDAPI_RWRITE,
     var_mteTriggerThresholdTable, 2, {1, 10}},
#define   MTETRIGGERTHRESHOLDFALLINGEVENT  13
    {MTETRIGGERTHRESHOLDFALLINGEVENT, ASN_OCTET_STR, NETSNMP_OLDAPI_RWRITE,
     var_mteTriggerThresholdTable, 2, {1, 11}},
#define   MTETRIGGERTHRESHOLDDELTARISINGEVENTOWNER  14
    {MTETRIGGERTHRESHOLDDELTARISINGEVENTOWNER, ASN_OCTET_STR, NETSNMP_OLDAPI_RWRITE,
     var_mteTriggerThresholdTable, 2, {1, 12}},
#define   MTETRIGGERTHRESHOLDDELTARISINGEVENT  15
    {MTETRIGGERTHRESHOLDDELTARISINGEVENT, ASN_OCTET_STR, NETSNMP_OLDAPI_RWRITE,
     var_mteTriggerThresholdTable, 2, {1, 13}},
#define   MTETRIGGERTHRESHOLDDELTAFALLINGEVENTOWNER  16
    {MTETRIGGERTHRESHOLDDELTAFALLINGEVENTOWNER, ASN_OCTET_STR, NETSNMP_OLDAPI_RWRITE,
     var_mteTriggerThresholdTable, 2, {1, 14}},
#define   MTETRIGGERTHRESHOLDDELTAFALLINGEVENT  17
    {MTETRIGGERTHRESHOLDDELTAFALLINGEVENT, ASN_OCTET_STR, NETSNMP_OLDAPI_RWRITE,
     var_mteTriggerThresholdTable, 2, {1, 15}},
};
#else /* !NETSNMP_NO_WRITE_SUPPORT */
struct variable2 mteTriggerThresholdTable_variables[] = {
    /*
     * magic number        , variable type , ro/rw , callback fn  , L, oidsuffix 
     */
#define   MTETRIGGERTHRESHOLDSTARTUP  3
    {MTETRIGGERTHRESHOLDSTARTUP, ASN_INTEGER, NETSNMP_OLDAPI_RONLY,
     var_mteTriggerThresholdTable, 2, {1, 1}},
#define   MTETRIGGERTHRESHOLDRISING  4
    {MTETRIGGERTHRESHOLDRISING, ASN_INTEGER, NETSNMP_OLDAPI_RONLY,
     var_mteTriggerThresholdTable, 2, {1, 2}},
#define   MTETRIGGERTHRESHOLDFALLING  5
    {MTETRIGGERTHRESHOLDFALLING, ASN_INTEGER, NETSNMP_OLDAPI_RONLY,
     var_mteTriggerThresholdTable, 2, {1, 3}},
#define   MTETRIGGERTHRESHOLDDELTARISING  6
    {MTETRIGGERTHRESHOLDDELTARISING, ASN_INTEGER, NETSNMP_OLDAPI_RONLY,
     var_mteTriggerThresholdTable, 2, {1, 4}},
#define   MTETRIGGERTHRESHOLDDELTAFALLING  7
    {MTETRIGGERTHRESHOLDDELTAFALLING, ASN_INTEGER, NETSNMP_OLDAPI_RONLY,
     var_mteTriggerThresholdTable, 2, {1, 5}},
#define   MTETRIGGERTHRESHOLDOBJECTSOWNER  8
    {MTETRIGGERTHRESHOLDOBJECTSOWNER, ASN_OCTET_STR, NETSNMP_OLDAPI_RONLY,
     var_mteTriggerThresholdTable, 2, {1, 6}},
#define   MTETRIGGERTHRESHOLDOBJECTS  9
    {MTETRIGGERTHRESHOLDOBJECTS, ASN_OCTET_STR, NETSNMP_OLDAPI_RONLY,
     var_mteTriggerThresholdTable, 2, {1, 7}},
#define   MTETRIGGERTHRESHOLDRISINGEVENTOWNER  10
    {MTETRIGGERTHRESHOLDRISINGEVENTOWNER, ASN_OCTET_STR, NETSNMP_OLDAPI_RONLY,
     var_mteTriggerThresholdTable, 2, {1, 8}},
#define   MTETRIGGERTHRESHOLDRISINGEVENT  11
    {MTETRIGGERTHRESHOLDRISINGEVENT, ASN_OCTET_STR, NETSNMP_OLDAPI_RONLY,
     var_mteTriggerThresholdTable, 2, {1, 9}},
#define   MTETRIGGERTHRESHOLDFALLINGEVENTOWNER  12
    {MTETRIGGERTHRESHOLDFALLINGEVENTOWNER, ASN_OCTET_STR, NETSNMP_OLDAPI_RONLY,
     var_mteTriggerThresholdTable, 2, {1, 10}},
#define   MTETRIGGERTHRESHOLDFALLINGEVENT  13
    {MTETRIGGERTHRESHOLDFALLINGEVENT, ASN_OCTET_STR, NETSNMP_OLDAPI_RONLY,
     var_mteTriggerThresholdTable, 2, {1, 11}},
#define   MTETRIGGERTHRESHOLDDELTARISINGEVENTOWNER  14
    {MTETRIGGERTHRESHOLDDELTARISINGEVENTOWNER, ASN_OCTET_STR, NETSNMP_OLDAPI_RONLY,
     var_mteTriggerThresholdTable, 2, {1, 12}},
#define   MTETRIGGERTHRESHOLDDELTARISINGEVENT  15
    {MTETRIGGERTHRESHOLDDELTARISINGEVENT, ASN_OCTET_STR, NETSNMP_OLDAPI_RONLY,
     var_mteTriggerThresholdTable, 2, {1, 13}},
#define   MTETRIGGERTHRESHOLDDELTAFALLINGEVENTOWNER  16
    {MTETRIGGERTHRESHOLDDELTAFALLINGEVENTOWNER, ASN_OCTET_STR, NETSNMP_OLDAPI_RONLY,
     var_mteTriggerThresholdTable, 2, {1, 14}},
#define   MTETRIGGERTHRESHOLDDELTAFALLINGEVENT  17
    {MTETRIGGERTHRESHOLDDELTAFALLINGEVENT, ASN_OCTET_STR, NETSNMP_OLDAPI_RONLY,
     var_mteTriggerThresholdTable, 2, {1, 15}},
};
#endif /* !NETSNMP_NO_WRITE_SUPPORT */


/*
 * (L = length of the oidsuffix) 
 */


/*
 * init_mteTriggerThresholdTable():
 *   Initialization routine.  This is called when the agent starts up.
 *   At a minimum, registration of your variables should take place here.
 */
void
init_mteTriggerThresholdTable(void)
{
    DEBUGMSGTL(("mteTriggerThresholdTable", "initializing...  "));


    /*
     * register ourselves with the agent to handle our mib tree 
     */
    REGISTER_MIB("mteTriggerThresholdTable",
                 mteTriggerThresholdTable_variables, variable2,
                 mteTriggerThresholdTable_variables_oid);


    DEBUGMSGTL(("mteTriggerThresholdTable", "done.\n"));
}

/*
 * var_mteTriggerThresholdTable():
 *   Handle this table separately from the scalar value case.
 *   The workings of this are basically the same as for var_mteTriggerThresholdTable above.
 */
unsigned char  *
var_mteTriggerThresholdTable(struct variable *vp,
                             oid * name,
                             size_t * length,
                             int exact,
                             size_t * var_len, WriteMethod ** write_method)
{


    struct mteTriggerTable_data *StorageTmp = NULL;


    DEBUGMSGTL(("mteTriggerThresholdTable",
                "var_mteTriggerThresholdTable: Entering...  \n"));

	/* set default value */
	*write_method = NULL;

    /*
     * this assumes you have registered all your data properly
     */
    if ((StorageTmp =
         header_complex(mteTriggerTableStorage, vp, name, length, exact,
                        var_len, write_method)) == NULL)
        return NULL;


    if (!(StorageTmp->mteTriggerTest[0] & MTETRIGGERTEST_THRESHOLD))
        return NULL;

    /*
     * this is where we do the value assignments for the mib results.
     */
    switch (vp->magic) {


    case MTETRIGGERTHRESHOLDSTARTUP:
#ifndef NETSNMP_NO_WRITE_SUPPORT
        *write_method = write_mteTriggerThresholdStartup;
#endif /* !NETSNMP_NO_WRITE_SUPPORT */
        *var_len = sizeof(StorageTmp->mteTriggerThresholdStartup);
        return (u_char *) & StorageTmp->mteTriggerThresholdStartup;

    case MTETRIGGERTHRESHOLDRISING:
#ifndef NETSNMP_NO_WRITE_SUPPORT
        *write_method = write_mteTriggerThresholdRising;
#endif /* !NETSNMP_NO_WRITE_SUPPORT */
        *var_len = sizeof(StorageTmp->mteTriggerThresholdRising);
        return (u_char *) & StorageTmp->mteTriggerThresholdRising;

    case MTETRIGGERTHRESHOLDFALLING:
#ifndef NETSNMP_NO_WRITE_SUPPORT
        *write_method = write_mteTriggerThresholdFalling;
#endif /* !NETSNMP_NO_WRITE_SUPPORT */
        *var_len = sizeof(StorageTmp->mteTriggerThresholdFalling);
        return (u_char *) & StorageTmp->mteTriggerThresholdFalling;

    case MTETRIGGERTHRESHOLDDELTARISING:
#ifndef NETSNMP_NO_WRITE_SUPPORT
        *write_method = write_mteTriggerThresholdDeltaRising;
#endif /* !NETSNMP_NO_WRITE_SUPPORT */
        *var_len = sizeof(StorageTmp->mteTriggerThresholdDeltaRising);
        return (u_char *) & StorageTmp->mteTriggerThresholdDeltaRising;

    case MTETRIGGERTHRESHOLDDELTAFALLING:
#ifndef NETSNMP_NO_WRITE_SUPPORT
        *write_method = write_mteTriggerThresholdDeltaFalling;
#endif /* !NETSNMP_NO_WRITE_SUPPORT */
        *var_len = sizeof(StorageTmp->mteTriggerThresholdDeltaFalling);
        return (u_char *) & StorageTmp->mteTriggerThresholdDeltaFalling;

    case MTETRIGGERTHRESHOLDOBJECTSOWNER:
#ifndef NETSNMP_NO_WRITE_SUPPORT
        *write_method = write_mteTriggerThresholdObjectsOwner;
#endif /* !NETSNMP_NO_WRITE_SUPPORT */
        *var_len = StorageTmp->mteTriggerThresholdObjectsOwnerLen;
        return (u_char *) StorageTmp->mteTriggerThresholdObjectsOwner;

    case MTETRIGGERTHRESHOLDOBJECTS:
#ifndef NETSNMP_NO_WRITE_SUPPORT
        *write_method = write_mteTriggerThresholdObjects;
#endif /* !NETSNMP_NO_WRITE_SUPPORT */
        *var_len = StorageTmp->mteTriggerThresholdObjectsLen;
        return (u_char *) StorageTmp->mteTriggerThresholdObjects;

    case MTETRIGGERTHRESHOLDRISINGEVENTOWNER:
#ifndef NETSNMP_NO_WRITE_SUPPORT
        *write_method = write_mteTriggerThresholdRisingEventOwner;
#endif /* !NETSNMP_NO_WRITE_SUPPORT */
        *var_len = StorageTmp->mteTriggerThresholdRisingEventOwnerLen;
        return (u_char *) StorageTmp->mteTriggerThresholdRisingEventOwner;

    case MTETRIGGERTHRESHOLDRISINGEVENT:
#ifndef NETSNMP_NO_WRITE_SUPPORT
        *write_method = write_mteTriggerThresholdRisingEvent;
#endif /* !NETSNMP_NO_WRITE_SUPPORT */
        *var_len = StorageTmp->mteTriggerThresholdRisingEventLen;
        return (u_char *) StorageTmp->mteTriggerThresholdRisingEvent;

    case MTETRIGGERTHRESHOLDFALLINGEVENTOWNER:
#ifndef NETSNMP_NO_WRITE_SUPPORT
        *write_method = write_mteTriggerThresholdFallingEventOwner;
#endif /* !NETSNMP_NO_WRITE_SUPPORT */
        *var_len = StorageTmp->mteTriggerThresholdFallingEventOwnerLen;
        return (u_char *) StorageTmp->mteTriggerThresholdFallingEventOwner;

    case MTETRIGGERTHRESHOLDFALLINGEVENT:
#ifndef NETSNMP_NO_WRITE_SUPPORT
        *write_method = write_mteTriggerThresholdFallingEvent;
#endif /* !NETSNMP_NO_WRITE_SUPPORT */
        *var_len = StorageTmp->mteTriggerThresholdFallingEventLen;
        return (u_char *) StorageTmp->mteTriggerThresholdFallingEvent;

    case MTETRIGGERTHRESHOLDDELTARISINGEVENTOWNER:
#ifndef NETSNMP_NO_WRITE_SUPPORT
        *write_method = write_mteTriggerThresholdDeltaRisingEventOwner;
#endif /* !NETSNMP_NO_WRITE_SUPPORT */
        *var_len = StorageTmp->mteTriggerThresholdDeltaRisingEventOwnerLen;
        return (u_char *) StorageTmp->
            mteTriggerThresholdDeltaRisingEventOwner;

    case MTETRIGGERTHRESHOLDDELTARISINGEVENT:
#ifndef NETSNMP_NO_WRITE_SUPPORT
        *write_method = write_mteTriggerThresholdDeltaRisingEvent;
#endif /* !NETSNMP_NO_WRITE_SUPPORT */
        *var_len = StorageTmp->mteTriggerThresholdDeltaRisingEventLen;
        return (u_char *) StorageTmp->mteTriggerThresholdDeltaRisingEvent;

    case MTETRIGGERTHRESHOLDDELTAFALLINGEVENTOWNER:
#ifndef NETSNMP_NO_WRITE_SUPPORT
        *write_method = write_mteTriggerThresholdDeltaFallingEventOwner;
#endif /* !NETSNMP_NO_WRITE_SUPPORT */
        *var_len =
            StorageTmp->mteTriggerThresholdDeltaFallingEventOwnerLen;
        return (u_char *) StorageTmp->
            mteTriggerThresholdDeltaFallingEventOwner;

    case MTETRIGGERTHRESHOLDDELTAFALLINGEVENT:
#ifndef NETSNMP_NO_WRITE_SUPPORT
        *write_method = write_mteTriggerThresholdDeltaFallingEvent;
#endif /* !NETSNMP_NO_WRITE_SUPPORT */
        *var_len = StorageTmp->mteTriggerThresholdDeltaFallingEventLen;
        return (u_char *) StorageTmp->mteTriggerThresholdDeltaFallingEvent;


    default:
        ERROR_MSG("");
    }
    return NULL;
}



#ifndef NETSNMP_NO_WRITE_SUPPORT 
int
write_mteTriggerThresholdStartup(int action,
                                 u_char * var_val,
                                 u_char var_val_type,
                                 size_t var_val_len,
                                 u_char * statP,
                                 oid * name, size_t name_len)
{
    static int      tmpvar;
    struct mteTriggerTable_data *StorageTmp = NULL;
    size_t          newlen =
        name_len -
        (sizeof(mteTriggerThresholdTable_variables_oid) / sizeof(oid) + 3 -
         1);


    DEBUGMSGTL(("mteTriggerThresholdTable",
                "write_mteTriggerThresholdStartup entering action=%d...  \n",
                action));
    if ((StorageTmp =
         header_complex(mteTriggerTableStorage, NULL,
                        &name[sizeof
                              (mteTriggerThresholdTable_variables_oid) /
                              sizeof(oid) + 3 - 1], &newlen, 1, NULL,
                        NULL)) == NULL)
        return SNMP_ERR_NOSUCHNAME;     /* remove if you support creation here */


    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            fprintf(stderr,
                    "write to mteTriggerThresholdStartup not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (StorageTmp->storageType != ST_NONVOLATILE)
            return SNMP_ERR_NOTWRITABLE;
        break;


    case RESERVE2:
        /*
         * memory reseveration, final preparation... 
         */
        break;


    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;


    case ACTION:
        /*
         * The variable has been stored in long_ret for
         * you to use, and you have just been asked to do something with
         * it.  Note that anything done here must be reversable in the UNDO case 
         */
        tmpvar = StorageTmp->mteTriggerThresholdStartup;
        StorageTmp->mteTriggerThresholdStartup = *((long *) var_val);
        break;


    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        StorageTmp->mteTriggerThresholdStartup = tmpvar;
        break;


    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail! 
         */

        break;
    }
    return SNMP_ERR_NOERROR;
}



int
write_mteTriggerThresholdRising(int action,
                                u_char * var_val,
                                u_char var_val_type,
                                size_t var_val_len,
                                u_char * statP,
                                oid * name, size_t name_len)
{
    static int      tmpvar;
    struct mteTriggerTable_data *StorageTmp = NULL;
    size_t          newlen =
        name_len -
        (sizeof(mteTriggerThresholdTable_variables_oid) / sizeof(oid) + 3 -
         1);


    DEBUGMSGTL(("mteTriggerThresholdTable",
                "write_mteTriggerThresholdRising entering action=%d...  \n",
                action));
    if ((StorageTmp =
         header_complex(mteTriggerTableStorage, NULL,
                        &name[sizeof
                              (mteTriggerThresholdTable_variables_oid) /
                              sizeof(oid) + 3 - 1], &newlen, 1, NULL,
                        NULL)) == NULL)
        return SNMP_ERR_NOSUCHNAME;     /* remove if you support creation here */


    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            fprintf(stderr,
                    "write to mteTriggerThresholdRising not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (StorageTmp->storageType != ST_NONVOLATILE)
            return SNMP_ERR_NOTWRITABLE;
        break;


    case RESERVE2:
        /*
         * memory reseveration, final preparation... 
         */
        break;


    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;


    case ACTION:
        /*
         * The variable has been stored in long_ret for
         * you to use, and you have just been asked to do something with
         * it.  Note that anything done here must be reversable in the UNDO case 
         */
        tmpvar = StorageTmp->mteTriggerThresholdRising;
        StorageTmp->mteTriggerThresholdRising = *((long *) var_val);
        break;


    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        StorageTmp->mteTriggerThresholdRising = tmpvar;
        break;


    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail! 
         */

        break;
    }
    return SNMP_ERR_NOERROR;
}



int
write_mteTriggerThresholdFalling(int action,
                                 u_char * var_val,
                                 u_char var_val_type,
                                 size_t var_val_len,
                                 u_char * statP,
                                 oid * name, size_t name_len)
{
    static int      tmpvar;
    struct mteTriggerTable_data *StorageTmp = NULL;
    size_t          newlen =
        name_len -
        (sizeof(mteTriggerThresholdTable_variables_oid) / sizeof(oid) + 3 -
         1);


    DEBUGMSGTL(("mteTriggerThresholdTable",
                "write_mteTriggerThresholdFalling entering action=%d...  \n",
                action));
    if ((StorageTmp =
         header_complex(mteTriggerTableStorage, NULL,
                        &name[sizeof
                              (mteTriggerThresholdTable_variables_oid) /
                              sizeof(oid) + 3 - 1], &newlen, 1, NULL,
                        NULL)) == NULL)
        return SNMP_ERR_NOSUCHNAME;     /* remove if you support creation here */


    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            fprintf(stderr,
                    "write to mteTriggerThresholdFalling not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (StorageTmp->storageType != ST_NONVOLATILE)
            return SNMP_ERR_NOTWRITABLE;
        break;


    case RESERVE2:
        /*
         * memory reseveration, final preparation... 
         */
        break;


    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;


    case ACTION:
        /*
         * The variable has been stored in long_ret for
         * you to use, and you have just been asked to do something with
         * it.  Note that anything done here must be reversable in the UNDO case 
         */
        tmpvar = StorageTmp->mteTriggerThresholdFalling;
        StorageTmp->mteTriggerThresholdFalling = *((long *) var_val);
        break;


    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        StorageTmp->mteTriggerThresholdFalling = tmpvar;
        break;


    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail! 
         */

        break;
    }
    return SNMP_ERR_NOERROR;
}



int
write_mteTriggerThresholdDeltaRising(int action,
                                     u_char * var_val,
                                     u_char var_val_type,
                                     size_t var_val_len,
                                     u_char * statP,
                                     oid * name, size_t name_len)
{
    static int      tmpvar;
    struct mteTriggerTable_data *StorageTmp = NULL;
    size_t          newlen =
        name_len -
        (sizeof(mteTriggerThresholdTable_variables_oid) / sizeof(oid) + 3 -
         1);


    DEBUGMSGTL(("mteTriggerThresholdTable",
                "write_mteTriggerThresholdDeltaRising entering action=%d...  \n",
                action));
    if ((StorageTmp =
         header_complex(mteTriggerTableStorage, NULL,
                        &name[sizeof
                              (mteTriggerThresholdTable_variables_oid) /
                              sizeof(oid) + 3 - 1], &newlen, 1, NULL,
                        NULL)) == NULL)
        return SNMP_ERR_NOSUCHNAME;     /* remove if you support creation here */


    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            fprintf(stderr,
                    "write to mteTriggerThresholdDeltaRising not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (StorageTmp->storageType != ST_NONVOLATILE)
            return SNMP_ERR_NOTWRITABLE;
        break;


    case RESERVE2:
        /*
         * memory reseveration, final preparation... 
         */
        break;


    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;


    case ACTION:
        /*
         * The variable has been stored in long_ret for
         * you to use, and you have just been asked to do something with
         * it.  Note that anything done here must be reversable in the UNDO case 
         */
        tmpvar = StorageTmp->mteTriggerThresholdDeltaRising;
        StorageTmp->mteTriggerThresholdDeltaRising = *((long *) var_val);
        break;


    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        StorageTmp->mteTriggerThresholdDeltaRising = tmpvar;
        break;


    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail! 
         */

        break;
    }
    return SNMP_ERR_NOERROR;
}



int
write_mteTriggerThresholdDeltaFalling(int action,
                                      u_char * var_val,
                                      u_char var_val_type,
                                      size_t var_val_len,
                                      u_char * statP,
                                      oid * name, size_t name_len)
{
    static int      tmpvar;
    struct mteTriggerTable_data *StorageTmp = NULL;
    size_t          newlen =
        name_len -
        (sizeof(mteTriggerThresholdTable_variables_oid) / sizeof(oid) + 3 -
         1);


    DEBUGMSGTL(("mteTriggerThresholdTable",
                "write_mteTriggerThresholdDeltaFalling entering action=%d...  \n",
                action));
    if ((StorageTmp =
         header_complex(mteTriggerTableStorage, NULL,
                        &name[sizeof
                              (mteTriggerThresholdTable_variables_oid) /
                              sizeof(oid) + 3 - 1], &newlen, 1, NULL,
                        NULL)) == NULL)
        return SNMP_ERR_NOSUCHNAME;     /* remove if you support creation here */


    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            fprintf(stderr,
                    "write to mteTriggerThresholdDeltaFalling not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (StorageTmp->storageType != ST_NONVOLATILE)
            return SNMP_ERR_NOTWRITABLE;
        break;


    case RESERVE2:
        /*
         * memory reseveration, final preparation... 
         */
        break;


    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;


    case ACTION:
        /*
         * The variable has been stored in long_ret for
         * you to use, and you have just been asked to do something with
         * it.  Note that anything done here must be reversable in the UNDO case 
         */
        tmpvar = StorageTmp->mteTriggerThresholdDeltaFalling;
        StorageTmp->mteTriggerThresholdDeltaFalling = *((long *) var_val);
        break;


    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        StorageTmp->mteTriggerThresholdDeltaFalling = tmpvar;
        break;


    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail! 
         */

        break;
    }
    return SNMP_ERR_NOERROR;
}



int
write_mteTriggerThresholdObjectsOwner(int action,
                                      u_char * var_val,
                                      u_char var_val_type,
                                      size_t var_val_len,
                                      u_char * statP,
                                      oid * name, size_t name_len)
{
    static char    *tmpvar;
    struct mteTriggerTable_data *StorageTmp = NULL;
    static size_t   tmplen;
    size_t          newlen =
        name_len -
        (sizeof(mteTriggerThresholdTable_variables_oid) / sizeof(oid) + 3 -
         1);


    DEBUGMSGTL(("mteTriggerThresholdTable",
                "write_mteTriggerThresholdObjectsOwner entering action=%d...  \n",
                action));
    if ((StorageTmp =
         header_complex(mteTriggerTableStorage, NULL,
                        &name[sizeof
                              (mteTriggerThresholdTable_variables_oid) /
                              sizeof(oid) + 3 - 1], &newlen, 1, NULL,
                        NULL)) == NULL)
        return SNMP_ERR_NOSUCHNAME;     /* remove if you support creation here */


    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_OCTET_STR) {
            fprintf(stderr,
                    "write to mteTriggerThresholdObjectsOwner not ASN_OCTET_STR\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (StorageTmp->storageType != ST_NONVOLATILE)
            return SNMP_ERR_NOTWRITABLE;
        break;


    case RESERVE2:
        /*
         * memory reseveration, final preparation... 
         */
        break;


    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;


    case ACTION:
        /*
         * The variable has been stored in string for
         * you to use, and you have just been asked to do something with
         * it.  Note that anything done here must be reversable in the UNDO case 
         */
        tmpvar = StorageTmp->mteTriggerThresholdObjectsOwner;
        tmplen = StorageTmp->mteTriggerThresholdObjectsOwnerLen;
        StorageTmp->mteTriggerThresholdObjectsOwner =
            netsnmp_memdup(var_val, var_val_len);
        StorageTmp->mteTriggerThresholdObjectsOwnerLen = var_val_len;
        break;


    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        SNMP_FREE(StorageTmp->mteTriggerThresholdObjectsOwner);
        StorageTmp->mteTriggerThresholdObjectsOwner = tmpvar;
        StorageTmp->mteTriggerThresholdObjectsOwnerLen = tmplen;
        break;


    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail! 
         */
        SNMP_FREE(tmpvar);
        break;
    }
    return SNMP_ERR_NOERROR;
}



int
write_mteTriggerThresholdObjects(int action,
                                 u_char * var_val,
                                 u_char var_val_type,
                                 size_t var_val_len,
                                 u_char * statP,
                                 oid * name, size_t name_len)
{
    static char    *tmpvar;
    struct mteTriggerTable_data *StorageTmp = NULL;
    static size_t   tmplen;
    size_t          newlen =
        name_len -
        (sizeof(mteTriggerThresholdTable_variables_oid) / sizeof(oid) + 3 -
         1);


    DEBUGMSGTL(("mteTriggerThresholdTable",
                "write_mteTriggerThresholdObjects entering action=%d...  \n",
                action));
    if ((StorageTmp =
         header_complex(mteTriggerTableStorage, NULL,
                        &name[sizeof
                              (mteTriggerThresholdTable_variables_oid) /
                              sizeof(oid) + 3 - 1], &newlen, 1, NULL,
                        NULL)) == NULL)
        return SNMP_ERR_NOSUCHNAME;     /* remove if you support creation here */


    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_OCTET_STR) {
            fprintf(stderr,
                    "write to mteTriggerThresholdObjects not ASN_OCTET_STR\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (StorageTmp->storageType != ST_NONVOLATILE)
            return SNMP_ERR_NOTWRITABLE;
        break;


    case RESERVE2:
        /*
         * memory reseveration, final preparation... 
         */
        break;


    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;


    case ACTION:
        /*
         * The variable has been stored in string for
         * you to use, and you have just been asked to do something with
         * it.  Note that anything done here must be reversable in the UNDO case 
         */
        tmpvar = StorageTmp->mteTriggerThresholdObjects;
        tmplen = StorageTmp->mteTriggerThresholdObjectsLen;
        StorageTmp->mteTriggerThresholdObjects =
            netsnmp_memdup(var_val, var_val_len);
        StorageTmp->mteTriggerThresholdObjectsLen = var_val_len;
        break;


    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        SNMP_FREE(StorageTmp->mteTriggerThresholdObjects);
        StorageTmp->mteTriggerThresholdObjects = tmpvar;
        StorageTmp->mteTriggerThresholdObjectsLen = tmplen;
        break;


    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail! 
         */
        SNMP_FREE(tmpvar);
        break;
    }
    return SNMP_ERR_NOERROR;
}



int
write_mteTriggerThresholdRisingEventOwner(int action,
                                          u_char * var_val,
                                          u_char var_val_type,
                                          size_t var_val_len,
                                          u_char * statP,
                                          oid * name, size_t name_len)
{
    static char    *tmpvar;
    struct mteTriggerTable_data *StorageTmp = NULL;
    static size_t   tmplen;
    size_t          newlen =
        name_len -
        (sizeof(mteTriggerThresholdTable_variables_oid) / sizeof(oid) + 3 -
         1);


    DEBUGMSGTL(("mteTriggerThresholdTable",
                "write_mteTriggerThresholdRisingEventOwner entering action=%d...  \n",
                action));
    if ((StorageTmp =
         header_complex(mteTriggerTableStorage, NULL,
                        &name[sizeof
                              (mteTriggerThresholdTable_variables_oid) /
                              sizeof(oid) + 3 - 1], &newlen, 1, NULL,
                        NULL)) == NULL)
        return SNMP_ERR_NOSUCHNAME;     /* remove if you support creation here */


    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_OCTET_STR) {
            fprintf(stderr,
                    "write to mteTriggerThresholdRisingEventOwner not ASN_OCTET_STR\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (StorageTmp->storageType != ST_NONVOLATILE)
            return SNMP_ERR_NOTWRITABLE;
        break;


    case RESERVE2:
        /*
         * memory reseveration, final preparation... 
         */
        break;


    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;


    case ACTION:
        /*
         * The variable has been stored in string for
         * you to use, and you have just been asked to do something with
         * it.  Note that anything done here must be reversable in the UNDO case 
         */
        tmpvar = StorageTmp->mteTriggerThresholdRisingEventOwner;
        tmplen = StorageTmp->mteTriggerThresholdRisingEventOwnerLen;
        StorageTmp->mteTriggerThresholdRisingEventOwner =
            netsnmp_memdup(var_val, var_val_len);
        StorageTmp->mteTriggerThresholdRisingEventOwnerLen = var_val_len;
        break;


    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        SNMP_FREE(StorageTmp->mteTriggerThresholdRisingEventOwner);
        StorageTmp->mteTriggerThresholdRisingEventOwner = tmpvar;
        StorageTmp->mteTriggerThresholdRisingEventOwnerLen = tmplen;
        break;


    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail! 
         */
        SNMP_FREE(tmpvar);
        break;
    }
    return SNMP_ERR_NOERROR;
}



int
write_mteTriggerThresholdRisingEvent(int action,
                                     u_char * var_val,
                                     u_char var_val_type,
                                     size_t var_val_len,
                                     u_char * statP,
                                     oid * name, size_t name_len)
{
    static char    *tmpvar;
    struct mteTriggerTable_data *StorageTmp = NULL;
    static size_t   tmplen;
    size_t          newlen =
        name_len -
        (sizeof(mteTriggerThresholdTable_variables_oid) / sizeof(oid) + 3 -
         1);


    DEBUGMSGTL(("mteTriggerThresholdTable",
                "write_mteTriggerThresholdRisingEvent entering action=%d...  \n",
                action));
    if ((StorageTmp =
         header_complex(mteTriggerTableStorage, NULL,
                        &name[sizeof
                              (mteTriggerThresholdTable_variables_oid) /
                              sizeof(oid) + 3 - 1], &newlen, 1, NULL,
                        NULL)) == NULL)
        return SNMP_ERR_NOSUCHNAME;     /* remove if you support creation here */


    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_OCTET_STR) {
            fprintf(stderr,
                    "write to mteTriggerThresholdRisingEvent not ASN_OCTET_STR\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (StorageTmp->storageType != ST_NONVOLATILE)
            return SNMP_ERR_NOTWRITABLE;
        break;


    case RESERVE2:
        /*
         * memory reseveration, final preparation... 
         */
        break;


    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;


    case ACTION:
        /*
         * The variable has been stored in string for
         * you to use, and you have just been asked to do something with
         * it.  Note that anything done here must be reversable in the UNDO case 
         */
        tmpvar = StorageTmp->mteTriggerThresholdRisingEvent;
        tmplen = StorageTmp->mteTriggerThresholdRisingEventLen;
        StorageTmp->mteTriggerThresholdRisingEvent =
            netsnmp_memdup(var_val, var_val_len);
        StorageTmp->mteTriggerThresholdRisingEventLen = var_val_len;
        break;


    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        SNMP_FREE(StorageTmp->mteTriggerThresholdRisingEvent);
        StorageTmp->mteTriggerThresholdRisingEvent = tmpvar;
        StorageTmp->mteTriggerThresholdRisingEventLen = tmplen;
        break;


    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail! 
         */
        SNMP_FREE(tmpvar);
        break;
    }
    return SNMP_ERR_NOERROR;
}



int
write_mteTriggerThresholdFallingEventOwner(int action,
                                           u_char * var_val,
                                           u_char var_val_type,
                                           size_t var_val_len,
                                           u_char * statP,
                                           oid * name, size_t name_len)
{
    static char    *tmpvar;
    struct mteTriggerTable_data *StorageTmp = NULL;
    static size_t   tmplen;
    size_t          newlen =
        name_len -
        (sizeof(mteTriggerThresholdTable_variables_oid) / sizeof(oid) + 3 -
         1);


    DEBUGMSGTL(("mteTriggerThresholdTable",
                "write_mteTriggerThresholdFallingEventOwner entering action=%d...  \n",
                action));
    if ((StorageTmp =
         header_complex(mteTriggerTableStorage, NULL,
                        &name[sizeof
                              (mteTriggerThresholdTable_variables_oid) /
                              sizeof(oid) + 3 - 1], &newlen, 1, NULL,
                        NULL)) == NULL)
        return SNMP_ERR_NOSUCHNAME;     /* remove if you support creation here */


    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_OCTET_STR) {
            fprintf(stderr,
                    "write to mteTriggerThresholdFallingEventOwner not ASN_OCTET_STR\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (StorageTmp->storageType != ST_NONVOLATILE)
            return SNMP_ERR_NOTWRITABLE;
        break;


    case RESERVE2:
        /*
         * memory reseveration, final preparation... 
         */
        break;


    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;


    case ACTION:
        /*
         * The variable has been stored in string for
         * you to use, and you have just been asked to do something with
         * it.  Note that anything done here must be reversable in the UNDO case 
         */
        tmpvar = StorageTmp->mteTriggerThresholdFallingEventOwner;
        tmplen = StorageTmp->mteTriggerThresholdFallingEventOwnerLen;
        StorageTmp->mteTriggerThresholdFallingEventOwner =
            netsnmp_memdup(var_val, var_val_len);
        StorageTmp->mteTriggerThresholdFallingEventOwnerLen = var_val_len;
        break;


    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        SNMP_FREE(StorageTmp->mteTriggerThresholdFallingEventOwner);
        StorageTmp->mteTriggerThresholdFallingEventOwner = tmpvar;
        StorageTmp->mteTriggerThresholdFallingEventOwnerLen = tmplen;
        break;


    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail! 
         */
        SNMP_FREE(tmpvar);
        break;
    }
    return SNMP_ERR_NOERROR;
}



int
write_mteTriggerThresholdFallingEvent(int action,
                                      u_char * var_val,
                                      u_char var_val_type,
                                      size_t var_val_len,
                                      u_char * statP,
                                      oid * name, size_t name_len)
{
    static char    *tmpvar;
    struct mteTriggerTable_data *StorageTmp = NULL;
    static size_t   tmplen;
    size_t          newlen =
        name_len -
        (sizeof(mteTriggerThresholdTable_variables_oid) / sizeof(oid) + 3 -
         1);


    DEBUGMSGTL(("mteTriggerThresholdTable",
                "write_mteTriggerThresholdFallingEvent entering action=%d...  \n",
                action));
    if ((StorageTmp =
         header_complex(mteTriggerTableStorage, NULL,
                        &name[sizeof
                              (mteTriggerThresholdTable_variables_oid) /
                              sizeof(oid) + 3 - 1], &newlen, 1, NULL,
                        NULL)) == NULL)
        return SNMP_ERR_NOSUCHNAME;     /* remove if you support creation here */


    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_OCTET_STR) {
            fprintf(stderr,
                    "write to mteTriggerThresholdFallingEvent not ASN_OCTET_STR\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (StorageTmp->storageType != ST_NONVOLATILE)
            return SNMP_ERR_NOTWRITABLE;
        break;


    case RESERVE2:
        /*
         * memory reseveration, final preparation... 
         */
        break;


    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;


    case ACTION:
        /*
         * The variable has been stored in string for
         * you to use, and you have just been asked to do something with
         * it.  Note that anything done here must be reversable in the UNDO case 
         */
        tmpvar = StorageTmp->mteTriggerThresholdFallingEvent;
        tmplen = StorageTmp->mteTriggerThresholdFallingEventLen;
        StorageTmp->mteTriggerThresholdFallingEvent =
            netsnmp_memdup(var_val, var_val_len);
        StorageTmp->mteTriggerThresholdFallingEventLen = var_val_len;
        break;


    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        SNMP_FREE(StorageTmp->mteTriggerThresholdFallingEvent);
        StorageTmp->mteTriggerThresholdFallingEvent = tmpvar;
        StorageTmp->mteTriggerThresholdFallingEventLen = tmplen;
        break;


    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail! 
         */
        SNMP_FREE(tmpvar);
        break;
    }
    return SNMP_ERR_NOERROR;
}



int
write_mteTriggerThresholdDeltaRisingEventOwner(int action,
                                               u_char * var_val,
                                               u_char var_val_type,
                                               size_t var_val_len,
                                               u_char * statP,
                                               oid * name, size_t name_len)
{
    static char    *tmpvar;
    struct mteTriggerTable_data *StorageTmp = NULL;
    static size_t   tmplen;
    size_t          newlen =
        name_len -
        (sizeof(mteTriggerThresholdTable_variables_oid) / sizeof(oid) + 3 -
         1);


    DEBUGMSGTL(("mteTriggerThresholdTable",
                "write_mteTriggerThresholdDeltaRisingEventOwner entering action=%d...  \n",
                action));
    if ((StorageTmp =
         header_complex(mteTriggerTableStorage, NULL,
                        &name[sizeof
                              (mteTriggerThresholdTable_variables_oid) /
                              sizeof(oid) + 3 - 1], &newlen, 1, NULL,
                        NULL)) == NULL)
        return SNMP_ERR_NOSUCHNAME;     /* remove if you support creation here */


    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_OCTET_STR) {
            fprintf(stderr,
                    "write to mteTriggerThresholdDeltaRisingEventOwner not ASN_OCTET_STR\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (StorageTmp->storageType != ST_NONVOLATILE)
            return SNMP_ERR_NOTWRITABLE;
        break;


    case RESERVE2:
        /*
         * memory reseveration, final preparation... 
         */
        break;


    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;


    case ACTION:
        /*
         * The variable has been stored in string for
         * you to use, and you have just been asked to do something with
         * it.  Note that anything done here must be reversable in the UNDO case 
         */
        tmpvar = StorageTmp->mteTriggerThresholdDeltaRisingEventOwner;
        tmplen = StorageTmp->mteTriggerThresholdDeltaRisingEventOwnerLen;
        StorageTmp->mteTriggerThresholdDeltaRisingEventOwner =
            netsnmp_memdup(var_val, var_val_len);
        StorageTmp->mteTriggerThresholdDeltaRisingEventOwnerLen =
            var_val_len;
        break;


    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        SNMP_FREE(StorageTmp->mteTriggerThresholdDeltaRisingEventOwner);
        StorageTmp->mteTriggerThresholdDeltaRisingEventOwner = tmpvar;
        StorageTmp->mteTriggerThresholdDeltaRisingEventOwnerLen = tmplen;
        break;


    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail! 
         */
        SNMP_FREE(tmpvar);
        break;
    }
    return SNMP_ERR_NOERROR;
}



int
write_mteTriggerThresholdDeltaRisingEvent(int action,
                                          u_char * var_val,
                                          u_char var_val_type,
                                          size_t var_val_len,
                                          u_char * statP,
                                          oid * name, size_t name_len)
{
    static char    *tmpvar;
    struct mteTriggerTable_data *StorageTmp = NULL;
    static size_t   tmplen;
    size_t          newlen =
        name_len -
        (sizeof(mteTriggerThresholdTable_variables_oid) / sizeof(oid) + 3 -
         1);


    DEBUGMSGTL(("mteTriggerThresholdTable",
                "write_mteTriggerThresholdDeltaRisingEvent entering action=%d...  \n",
                action));
    if ((StorageTmp =
         header_complex(mteTriggerTableStorage, NULL,
                        &name[sizeof
                              (mteTriggerThresholdTable_variables_oid) /
                              sizeof(oid) + 3 - 1], &newlen, 1, NULL,
                        NULL)) == NULL)
        return SNMP_ERR_NOSUCHNAME;     /* remove if you support creation here */


    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_OCTET_STR) {
            fprintf(stderr,
                    "write to mteTriggerThresholdDeltaRisingEvent not ASN_OCTET_STR\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (StorageTmp->storageType != ST_NONVOLATILE)
            return SNMP_ERR_NOTWRITABLE;
        break;


    case RESERVE2:
        /*
         * memory reseveration, final preparation... 
         */
        break;


    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;


    case ACTION:
        /*
         * The variable has been stored in string for
         * you to use, and you have just been asked to do something with
         * it.  Note that anything done here must be reversable in the UNDO case 
         */
        tmpvar = StorageTmp->mteTriggerThresholdDeltaRisingEvent;
        tmplen = StorageTmp->mteTriggerThresholdDeltaRisingEventLen;
        StorageTmp->mteTriggerThresholdDeltaRisingEvent =
            netsnmp_memdup(var_val, var_val_len);
        StorageTmp->mteTriggerThresholdDeltaRisingEventLen = var_val_len;
        break;


    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        SNMP_FREE(StorageTmp->mteTriggerThresholdDeltaRisingEvent);
        StorageTmp->mteTriggerThresholdDeltaRisingEvent = tmpvar;
        StorageTmp->mteTriggerThresholdDeltaRisingEventLen = tmplen;
        break;


    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail! 
         */
        SNMP_FREE(tmpvar);
        break;
    }
    return SNMP_ERR_NOERROR;
}



int
write_mteTriggerThresholdDeltaFallingEventOwner(int action,
                                                u_char * var_val,
                                                u_char var_val_type,
                                                size_t var_val_len,
                                                u_char * statP,
                                                oid * name,
                                                size_t name_len)
{
    static char    *tmpvar;
    struct mteTriggerTable_data *StorageTmp = NULL;
    static size_t   tmplen;
    size_t          newlen =
        name_len -
        (sizeof(mteTriggerThresholdTable_variables_oid) / sizeof(oid) + 3 -
         1);


    DEBUGMSGTL(("mteTriggerThresholdTable",
                "write_mteTriggerThresholdDeltaFallingEventOwner entering action=%d...  \n",
                action));
    if ((StorageTmp =
         header_complex(mteTriggerTableStorage, NULL,
                        &name[sizeof
                              (mteTriggerThresholdTable_variables_oid) /
                              sizeof(oid) + 3 - 1], &newlen, 1, NULL,
                        NULL)) == NULL)
        return SNMP_ERR_NOSUCHNAME;     /* remove if you support creation here */


    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_OCTET_STR) {
            fprintf(stderr,
                    "write to mteTriggerThresholdDeltaFallingEventOwner not ASN_OCTET_STR\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (StorageTmp->storageType != ST_NONVOLATILE)
            return SNMP_ERR_NOTWRITABLE;
        break;


    case RESERVE2:
        /*
         * memory reseveration, final preparation... 
         */
        break;


    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;


    case ACTION:
        /*
         * The variable has been stored in string for
         * you to use, and you have just been asked to do something with
         * it.  Note that anything done here must be reversable in the UNDO case 
         */
        tmpvar = StorageTmp->mteTriggerThresholdDeltaFallingEventOwner;
        tmplen = StorageTmp->mteTriggerThresholdDeltaFallingEventOwnerLen;
        StorageTmp->mteTriggerThresholdDeltaFallingEventOwner =
            netsnmp_memdup(var_val, var_val_len);
        StorageTmp->mteTriggerThresholdDeltaFallingEventOwnerLen =
            var_val_len;
        break;


    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        SNMP_FREE(StorageTmp->mteTriggerThresholdDeltaFallingEventOwner);
        StorageTmp->mteTriggerThresholdDeltaFallingEventOwner = tmpvar;
        StorageTmp->mteTriggerThresholdDeltaFallingEventOwnerLen = tmplen;
        break;


    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail! 
         */
        SNMP_FREE(tmpvar);
        break;
    }
    return SNMP_ERR_NOERROR;
}



int
write_mteTriggerThresholdDeltaFallingEvent(int action,
                                           u_char * var_val,
                                           u_char var_val_type,
                                           size_t var_val_len,
                                           u_char * statP,
                                           oid * name, size_t name_len)
{
    static char    *tmpvar;
    struct mteTriggerTable_data *StorageTmp = NULL;
    static size_t   tmplen;
    size_t          newlen =
        name_len -
        (sizeof(mteTriggerThresholdTable_variables_oid) / sizeof(oid) + 3 -
         1);


    DEBUGMSGTL(("mteTriggerThresholdTable",
                "write_mteTriggerThresholdDeltaFallingEvent entering action=%d...  \n",
                action));
    if ((StorageTmp =
         header_complex(mteTriggerTableStorage, NULL,
                        &name[sizeof
                              (mteTriggerThresholdTable_variables_oid) /
                              sizeof(oid) + 3 - 1], &newlen, 1, NULL,
                        NULL)) == NULL)
        return SNMP_ERR_NOSUCHNAME;     /* remove if you support creation here */


    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_OCTET_STR) {
            fprintf(stderr,
                    "write to mteTriggerThresholdDeltaFallingEvent not ASN_OCTET_STR\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (StorageTmp->storageType != ST_NONVOLATILE)
            return SNMP_ERR_NOTWRITABLE;
        break;


    case RESERVE2:
        /*
         * memory reseveration, final preparation... 
         */
        break;


    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;


    case ACTION:
        /*
         * The variable has been stored in string for
         * you to use, and you have just been asked to do something with
         * it.  Note that anything done here must be reversable in the UNDO case 
         */
        tmpvar = StorageTmp->mteTriggerThresholdDeltaFallingEvent;
        tmplen = StorageTmp->mteTriggerThresholdDeltaFallingEventLen;
        StorageTmp->mteTriggerThresholdDeltaFallingEvent =
            netsnmp_memdup(var_val, var_val_len);
        StorageTmp->mteTriggerThresholdDeltaFallingEventLen = var_val_len;
        break;


    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        SNMP_FREE(StorageTmp->mteTriggerThresholdDeltaFallingEvent);
        StorageTmp->mteTriggerThresholdDeltaFallingEvent = tmpvar;
        StorageTmp->mteTriggerThresholdDeltaFallingEventLen = tmplen;
        break;


    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail! 
         */
        SNMP_FREE(tmpvar);
        break;
    }
    return SNMP_ERR_NOERROR;
}

#endif /* !NETSNMP_NO_WRITE_SUPPORT */
